package w83b.w83bOperacionesPaso.w83bCitaciones;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bCitacionBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bOperacionesPaso.w83bMantenimientos.w83bConvenios.W83bTablaConveniosExcelAction;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaCitacionesExcelAction extends Q70ActionPasoOP{
	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListadoCitaciones.xls";
		InputStream inputStream = W83bTablaConveniosExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream); // Creacin del libro
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List lista = (ArrayList)contexto.get("w83bListaCitaciones");
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);

        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        
        
        HSSFHeader header = sheet.getHeader();//NOPMD
        header.setRight(W83bDateUtil.getInstance().getLocaleStringFromDate(new Date(), idioma));
        
        HSSFFooter footer = sheet.getFooter();//NOPMD

        footer.setCenter(((W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada());
        footer.setRight(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.label.pag",idioma,new String[]{footer.page()}));
        

        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        HashMap datosDelDep=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);
	    
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1
        HSSFCell cell = row.createCell((short)3);
        HSSFCell cell2 ;
        
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)3);
        
        StringBuffer tituloImagenEu = (StringBuffer)datosDelDep.get("tituloDepEu");
        StringBuffer tituloImagenEs = (StringBuffer)datosDelDep.get("tituloDepEs");
        
       
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)6); 
        cell.setCellValue(tituloImagenEs.toString());
        
        tituloImagenEu = (StringBuffer)datosDelDep.get("tituloDelelegacionEu");
        tituloImagenEs = (StringBuffer)datosDelDep.get("tituloDelelegacionEs");
        
       
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)3);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)6); 
        cell.setCellValue(tituloImagenEs.toString());
        
        row = sheet.getRow((short)9); 
        cell = row.getCell((short)2);
        StringBuffer titulo = new StringBuffer();
        titulo.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloCitaciones_eu",idioma));
        titulo.append(" ");
        titulo.append("\n");
        titulo.append(" ");
        titulo.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloCitaciones_es",idioma));
        cell.setCellValue(titulo.toString());
        
        //LUGAR
        
        row	 = sheet.getRow((short)11); 
   		cell=row.getCell((short)4);
   		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.citaciones.lugarMulti",idioma));
   		
   	
   		row	 = sheet.getRow((short)12); 
   		cell=row.getCell((short)2);
   		if(cell==null)
   		{
   			cell=row.createCell((short)2);
   		}
   		if(idioma.equals(W83bClsConstantes.CONSTANTE_EUSKARA))
   		{
   			cell.setCellValue(tituloImagenEu+ "\n" +usuario.getCalleListadosFormateada());
   		}else{
   			cell.setCellValue(tituloImagenEs+ "\n" +usuario.getCalleListadosFormateada());
   		}
   		
          
	    //int j=5;
   		int inicioRepeticion=13;
	 
	 		  //PREPARADO DE LOS LABELS QUE SE VAN A REPETIR
	   		
	   		/*row = sheet.getRow((short)inicioRepeticion+1); 
	   		cell=row.getCell((short)2);
	   		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.citaciones.diaMulti",idioma));*/
	   		
	   		/*cell=row.getCell((short)6);
	   		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.citaciones.horaMulti",idioma));*/
	   		
	   		/*row = sheet.getRow((short)inicioRepeticion+2); 
	   		cell=row.getCell((short)2);
	   		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.citaciones.numImpugnacionMulti",idioma));*/
	   		
	   		/*row = sheet.getRow((short)inicioRepeticion+3); 
	   		cell=row.getCell((short)2);
	   		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.citaciones.empresaMulti",idioma));*/
	   		
	   		/*row = sheet.getRow((short)inicioRepeticion+4); 
	   		cell=row.getCell((short)2);
	   		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.citaciones.aldeakMulti",idioma).replaceAll("/","/\n"));   		*/
	   		
	   		//DUPLICADO DE FILAS
		    /*  for(int z=1;lista!=null && z<lista.size();z++)
		      {
		      		
		      		excel.copyRow(wb, sheet,  inicioRepeticion+1,  inicioRepeticion+(j*z)+1);
		      		excel.copyRow(wb, sheet,  inicioRepeticion+2,  inicioRepeticion+(j*z)+2);
		      		excel.copyRow(wb, sheet,  inicioRepeticion+3,  inicioRepeticion+(j*z)+3);
		      		excel.copyRow(wb, sheet,  inicioRepeticion+4,  inicioRepeticion+(j*z)+4);
		      		excel.copyRow(wb, sheet,  inicioRepeticion+5,  inicioRepeticion+(j*z)+5);//linea separador
		    	 
		      }*/
		    //VOLCADO DE DATOS
		      W83bCitacionBean bean;
		      StringBuffer aldeak;
		      for(int z=0;lista!=null && z<lista.size();z++)
			      {
		    	   		
		    	  	bean=(W83bCitacionBean)lista.get(z);
		    	  	if(bean!=null)
		    	  	{
		    	  		inicioRepeticion=inicioRepeticion+1;
		    	  		row = sheet.createRow((short)inicioRepeticion); 
		    	   		cell=row.getCell((short)2);
		    	   		if (cell==null){
		    	   			cell=row.createCell((short)2);
		    	   		}
		    	   		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.citaciones.diaMulti",idioma));
		    	   		cell.setCellStyle(excel.estiloExcelCitacionesTitulos);
		    	   		
		    	  		//row = sheet.getRow((short)inicioRepeticion+(j*z)+1); 
		    	  		cell=row.getCell((short)3);
		    	  		cell2=row.getCell((short)4);
		    	  		if(cell==null)
		    	  		{
		    	  			cell=row.createCell((short)3);
		    	  		}
		    	  		if(cell2==null)
		    	  		{
		    	  			cell2=row.createCell((short)4);
		    	  		}
		    	  		sheet.addMergedRegion(new Region((short)inicioRepeticion,(short)3,(short)inicioRepeticion,(short)4)); //NOPMD
		    	  		if(StringUtils.isNotEmpty(bean.getFechaCitacion())){
		    	  			cell.setCellValue(bean.getFechaCitacion());
		    	  		}
		    	  		cell.setCellStyle(excel.estiloExcelCitaciones);
		    	  		cell=row.getCell((short)6);
		    	  		if(cell==null)
		    	  		{
		    	  			cell=row.createCell((short)6);
		    	  		}
		    	   		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.citaciones.horaMulti",idioma));
		    	   		cell.setCellStyle(excel.estiloExcelCitacionesTitulos);
		    	   		
		    	   		cell=row.getCell((short)7);
		    	   		cell2=row.getCell((short)8);
		    	   		if(cell==null)
		    	  		{
		    	  			cell=row.createCell((short)7);
		    	  		}
		    	   		if(cell2==null)
		    	  		{
		    	  			cell2=row.createCell((short)8);
		    	  		}
		    	   		sheet.addMergedRegion(new Region((short)inicioRepeticion,(short)7,(short)inicioRepeticion,(short)8)); //NOPMD
		    	   		if(StringUtils.isNotEmpty(bean.getHoraCitacionInicio())){
		    	   			cell.setCellValue(bean.getHoraCitacionInicio());
		    	   		}
		    	   		cell.setCellStyle(excel.estiloExcelCitaciones);
		    	   		inicioRepeticion=inicioRepeticion+1;
		    	   		row = sheet.createRow((short)inicioRepeticion); 
		    	   		cell=row.getCell((short)2);
		    	   		row.setHeight((short)848);
		    	   		if(cell==null)
		    	  		{
		    	  			cell=row.createCell((short)2);
		    	  		}
		    	   		if (bean.getNacta().charAt(0)=='a'){
		    	   			cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.citaciones.numacta",idioma));
	    				}
	    				else{
	    					cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.citaciones.numpreaviso",idioma));
	    				}
		    	   		cell.setCellStyle(excel.estiloExcelCitacionesTitulos);
		    	   		//cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.citaciones.numImpugnacionMulti",idioma));
		    	   		//row = sheet.getRow((short)inicioRepeticion+(j*z)+2); 
		    	   		cell=row.getCell((short)3);
		    	   		cell2=row.getCell((short)4);
		    	   		sheet.addMergedRegion(new Region((short)inicioRepeticion,(short)3,(short)inicioRepeticion,(short)4)); //NOPMD
		    	   		if(cell==null)
		    	  		{
		    	  			cell=row.createCell((short)3);
		    	  		}
		    	   		if(cell2==null)
		    	  		{
		    	  			cell2=row.createCell((short)4);
		    	  		}
		    	   		if(StringUtils.isNotEmpty(bean.getNacta().substring(1,bean.getNacta().length()))){
		    	   			cell.setCellValue(bean.getNacta().substring(1,bean.getNacta().length()));
		    	   		}
		    	   		cell.setCellStyle(excel.estiloExcelCitaciones);
		    	   		inicioRepeticion=inicioRepeticion+1;
		    	   		row = sheet.createRow((short)inicioRepeticion);
		    	   		row.setHeight((short)848);
		    	   		cell=row.getCell((short)2);
		    	   		if (cell==null){
		    	   			cell=row.createCell((short)2);
		    	   		}
		    	   		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.citaciones.empresaMulti",idioma));
		    	   		//row = sheet.getRow((short)inicioRepeticion+(j*z)+3); 
		    	   		cell.setCellStyle(excel.estiloExcelCitacionesTitulos);
		    	   		cell=row.getCell((short)3);
		    	   		if(cell==null)
		    	  		{
		    	  			cell=row.createCell((short)3);
		    	  		}
		    	   		if(cell2==null)
		    	  		{
		    	  			cell2=row.createCell((short)8);
		    	  		}
		    	   		sheet.addMergedRegion(new Region((short)inicioRepeticion,(short)3,(short)inicioRepeticion,(short)8)); //NOPMD
		    	   		if(StringUtils.isNotEmpty(bean.getCentroTrabajo().getRazonSocial())){
		    	   			cell.setCellValue(bean.getCentroTrabajo().getRazonSocial());
		    	   		}
		    	   		cell.setCellStyle(excel.estiloExcelCitaciones);
		    	   		inicioRepeticion=inicioRepeticion+1;
		    	   		row = sheet.createRow((short)inicioRepeticion); 
		    	   		row.setHeight((short)1158);
		    	   		cell=row.getCell((short)2);
		    	   		if (cell==null){
		    	   			cell=row.createCell((short)2);
		    	   		} 
		    	   		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.citaciones.aldeakMulti",idioma).replaceAll("/","/\n"));   		
		    	   		//row = sheet.getRow((short)inicioRepeticion+(j*z)+4); 
		    	   		cell.setCellStyle(excel.estiloExcelCitacionesTitulos);
		    	   		cell=row.getCell((short)3);
		    	   		cell2=row.getCell((short)8);
		    	   		if(cell==null)
		    	  		{
		    	  			cell=row.createCell((short)3);
		    	  		}
		    	   		if(cell2==null)
		    	  		{
		    	  			cell2=row.createCell((short)8);
		    	  		}
		    	   		sheet.addMergedRegion(new Region((short)inicioRepeticion,(short)3,(short)inicioRepeticion,(short)8)); //NOPMD
		    	   		aldeak=new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
		    	   		
		    	   		aldeak.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.citaciones.empresa",idioma)).append(", ");
		    	   		if(bean.getMesa().equals("1"))
		    	   		{
		    	   			aldeak.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.citaciones.mesa",idioma)).append(", ");
		    	   		}
		    	   		if(StringUtils.isNotEmpty(bean.getNombreImpug()))
		    	   		{
		    	   			aldeak.append(bean.getNombreImpug()).append(", ");
		    	   		}
		    	   		aldeak.append(bean.getSiglasSindicatos());
		    	   		cell.setCellValue(aldeak.toString());
		    	   		cell.setCellStyle(excel.estiloExcelCitaciones);
		    	   		inicioRepeticion=inicioRepeticion+1;
		    	   		row = sheet.createRow((short)inicioRepeticion); 
		    	   		row.setHeight((short)750);
		    	  	}
		    	   		
			    	 
			      }
			   
		  
	 	
   		
	  
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoCitaciones.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();
        response.getOutputStream().close();

		
		return null;
	}

}
